(

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			-- here you return the UUID of the AMG node or graph that implements this material/map
			--
			-- Example:
			--    "c0a9d104-c110-49f9-8cf7-82171c872bdd"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			-- here you add to the "res" array for each map connection, the syntax is:
			--
			--    append res #( <string parametername>, <mtl/map submap> [, <string output>, [<context>]] )
			--
			-- <output>  is optional and will be "result" if not specified.
			-- <context> is an integer passed down to the functions of the node being connected
			--
			-- Example:
			--    if mtl.diffuse_map != undefined and mtl.diffuse_map_on do
			--        append res #( "diffuse", mtl.diffuse_map )                  -- connect "result" of the map to "diffuse" parameter
			--    if mtl.roughness_map != undefined and mtl.rougness_map_on do
			--        append res #( "rougness", mtl.diffuse_map, "resultFloat" )  -- connect "resultFloat" of the map to "roughness" parameter
			--    if mtl.bump_map != undefined and mtl.bump_map_on do
			--        append res #( "bump", mtl.diffuse_map, "resultFloat" )  -- connect "resultFloat" of the map to "roughness" parameter

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			-- here you add to the "res" array for each map connection, the syntax is:
			--
			--    append res #( <string parametername>, <value of matching type> )
			--
			-- Example:
			--    append res #( "diffuse",  mtl.diffuse_color)                   
			--    append res #( "rougness", mtl.diffuse_roughness )  

 			res
		)
	)

	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCUldWn6Y6utrq09TV174m7oylJsJcaWgqx
-- iVIV24ChCbj1eODoBmPzggtuk7I81J2oaFzPaszzGvy1Q5UDdc2YkwH+plFaXMsC
-- X/yg+Yj3gh5eo3OqPTIXiKDVgAyzvE7Cqo9TkNOi36g2Ty6W5nsqLoGkHkwTbTXR
-- OVyPUhFhmKw/zW4ruz1w6yv6Yfe529IiHpYlHxp92gsMpcBqU8rvaSB1AnwCR3+U
-- iXC0UUiJ1OZPCjC//4o94UZRz323lWrFzmJSdO8ImlsccvSJdjEFOha8J9VJdlel
-- ivOyri52hHSdrSyybSZ+iwpqFy/QSY21AQtk93vQVN6wTAiCTKea
-- -----END-SIGNATURE-----